**********************************************************************************
*Project Name: PSQ
*Part: 
*Filename: psq.do
*Date: March 11, 2005
*Data: psq.dta
*Data2: economictv2.dta
*Summary: The goal of this batch file is to read the first data into state, join 
*it with the time-varying covariates and do some basic data analysis.
**********************************************************************************
*First, I need to do some housekeeping.
set memory 64000
set l 72
set level 95
set matsize 800

*Now I will read in the data and combine the agency data with the time-varying covariates.
use psq.dta
joinby year using economictv2.dta

*Stata needs to be told that this is time-series-cross-section data.

tsset agencyid year, yearly
xtdes

*Now to create the percentage politically appointed variables.
generate pcttotal=((schc+pas+noncareer)/emp)*100
by agencyid: generate dwage=avg-avg[_n-1] if year-1==year[_n-1]
by agencyid: generate ldwage=dwage[_n-1] if year-1==year[_n-1]
by agencyid: generate lwage=avg[_n-1]

sort agencyid year

by agencyid: generate dpartch=partch-partch[_n-1]
by agencyid: generate ldpartch=dpartch[_n-1]
by agencyid: generate lpartch=partch[_n-1]
by agencyid: generate reppres=0
replace reppres=1 if dempres==0
by agencyid: generate dreppres=reppres-reppres[_n-1]
by agencyid: generate dunified=unified-unified[_n-1]


*Now to create change in percentages.
by agencyid: generate dpcttotal=pcttotal-pcttotal[_n-1] if year~=1988&year~=2004 &year-1==year[_n-1]

generate omb=0
replace omb=1 if agencyid==150
generate cea=0
replace cea=1 if agencyid==180
generate offadmin=0
replace offadmin=1 if agencyid==270
generate ceq=0
replace ceq=1 if agencyid==320
generate nsc=0
replace nsc=1 if agencyid==620
generate ondcp=0
replace ondcp=1 if agencyid==690
generate ustr=0
replace ustr=1 if agencyid==810
generate ostp=0
replace ostp=1 if agencyid==830

*A couple of pictures
sort year

by year: egen avgpctt=mean(pcttotal)
lowess avgpctt year if agencyid~=270&agencyid~=340&agencyid~=620, ytitle("Percent Politically Appointed") xtitle("Year") title("Average Politicization in EOP, 1988-2004") note("")
more
graph bar (mean) dpcttotal, over(tyear, relabel(1 "Year 1" 2 "Year 2" 3 "Year 3" 4 "Year 4")) over(partchg, relabel(1 "No Party Change in White House" 2 "Party Change in White House")) title("Figure x. Politicization by Party Turnover in White House") ytitle("Average Change in Appointee %")

generate trend=year-1988
tab tyear, generate(yt)

*The commands for the models in Table 1 follow.  There are a few cases where the estimates that show up in the journal article
*are slightly different than what is estimated here.  They do not change the substantive conclusions. I note them below.  
tsset agencyid year

*Model 1, Table 1.
reg dpcttotal d.partch l.dpartch l.dwage yt1 yt2 yt3  trend if agencyid~= 340&agencyid~=620&agencyid~=270, cluster (year)

*Model 2, Table 1.
reg dpcttotal d.partch l.dpartch dwage l.dwage yt1 yt2 yt3  if agencyid~= 340&agencyid~=620&agencyid~=270, cluster (year)

*Model 3, Table 1.  [Note these estimates slightly different than what is in published article.]
reg dpcttotal d.partch l.dpartch l.dwage yt1 yt2 yt3 d.unified if agencyid~= 340&agencyid~=620&agencyid~=270, cluster (year)

*Model 4, Table 1.
reg dpcttotal d.partch l.dpartch l.dwage yt1 yt2 yt3 d.reppres if agencyid~= 340&agencyid~=620&agencyid~=270, cluster (year)

*Model 5, Table 1.  [Note these estimates slightly different than what is in published article.]
reg dpcttotal dpartch l.partch yt1 yt2 yt3  if agencyid~= 340&agencyid~=620&agencyid~=270, cluster (year)

*Model 6, Table 1.
reg dpcttotal dpartch l.dpartch l.dwage yt1 yt2 yt3  if agencyid~= 340, cluster (year)

*Now the commands to create the variables for supplementary analyses.

*Now I will create some of the necessary political variables.
generate prdist=abs(prescom-housemed)
generate sprdist=abs(prescom-senmed)
generate chdiff=abs(senmed-housemed)
generate abspd=abs(presdiff)

*Now agency employment
generate lnemp=ln(emp)
by agencyid: generate llnemp=lnemp[_n-1]
by agencyid: generate dlnemp=lnemp-lnemp[_n-1]
