****************************************************************************************************
*Title: Agencies by Presidential Design: Batch file with comments
*Author: William G. Howell and David E. Lewis
*
*Batch File for November 2002 JOP Article
*September 14, 2000
*****************************************************************************************************


use "C:\Stata\wpsa5.dta"

*****************************************************************************************************
*Notes about data and estimation:
*Data: The data is count data drawn from Lewis (2000/2003).  There are earlier versions of the wpsa5
*data, starting with wpsa.dta which was used for the first draft of this paper that was presented
*at the Western Meetings in 1999.  Wpsa agency is the lewis data where there are 400+
*observations and the dependent variable is the type of agency created.  wpsa5 is the data with the 
*weakness measure standardized from 0 to 1.  
*
*Notes about the testing of our theoretical expectations: We estimated the models with 11 different 
*measures of congressional weakness.  We used majority of house, senate, number of public laws, 
*group a laws from Cameron et al., the two weakness measures, std house, std senate, chamber 
*difference in common space scores, majority party difference in common space scores, and the 
*number of legislatively created agencies.  In full model specifications 5/11 were significant 
*at at least the .10 level in one-tailed tests and two more were close.  One specification suggested 
*an opposite finding.  In the specifications without war and unemp 6/11 were significant at at least 
*the .10 level in one-tailed tests and two more were close.  When using the abs difference between
*common space scores for the president and house median 7/11 significant at at least
*the .10 level and one more close.  With 50 cases we expect some volatility and we 
*find it.  In the whole, however, we believe the data support the hypotheses as long
*as we take them cautiously.  
*
*Since some measures confirmed our expectations and some washed out, however, we constructed what we
*thought was the most reasonable measure of congressional weakness and chose to use it without any 
*foreknowledge of the results it would produce to avoid the moral hazard problem.  These are the results
*we present in the paper.  Some results, like those with ADA scores wash out.  We do not report all the 
*cases where the results wash out just like we do not report all the cases where the results strongly 
*confirm our claims.  As we suggest above, our belief is that, on the whole, the results support our 
*findings.  We make this data available so that others my test for themselves.
*******************************************************************************************************

keep if year<1996

*I exclude 1996, 1997 since agencies created in these two years may not appear in the USGM until 1999-2000. 

*First, create the measure of weakness.  We take the standard deviation of the d-nom
*scores for the house and senate and normalize them by subtracting the mean and dividing
*by the standard deviation.  We do the same for the chamber difference and majority party
*chamber difference measures.

generate stdhdn_n=(std_h_dn-.2668735)/.0122553
generate stdsdn_n=(std_s_dn-.3151008)/.0091165
generate chdftw_n=(ch_df_tw-.06132)/.0373917
generate mpdftw_n=(mp_df_tw-.12392)/.1425259

*We then sum these measures to calculate a weakness measure.  The larger this value, the
*weaker congress is.

generate weak_tw=stdhdn_n+stdsdn_n+chdftw_n
generate weak2_tw=stdhdn_n+stdsdn_n+mpdftw_n

*Now we transform the chamber difference weakness measure so that it varies between 0 and 1. 
*We take the base score, add the abs of minimum and divide through by the max plus the min.
generate weaktwn=(weak_tw+abs(-3.296163))/(5.877523-(-3.296163))

*Below we transform the party median weakness measure so that it varies between 0 and 1.
generate wek2twn=(weak2_tw+abs(-2.711068))/abs(4.019769-(-2.711068))


summarize weaktwn wek2twn divided war unemploy approv trend

*Now to the full models.  First the weakness measure using chamber difference.
poisson counesec weaktwn divided war unemploy truman eisen kennedy johnson nixon ford carter reagan bush if year< 1996
lrtest, saving(0)
poisson counesec weaktwn divided war unemploy 
lrtest, using (0)
*Note the lrtest for the fixed effects.  Note the important fixed effects coefficients and s.e.s.

more
poisson counpma weaktwn divided war unemploy truman eisen kennedy johnson nixon ford carter reagan bush y1983 if year< 1996
poisson counpma weaktwn divided war unemploy truman eisen kennedy johnson nixon ford carter reagan bush y1983 if year< 1996
lrtest, saving (3)
poisson counpma weaktwn divided war unemploy y1983
lrtest, using (3)
*Note the chi square and df from the first model and then the lrtest and important fixed effects from the second.

more
poisson counpma wek2twn divided war unemploy truman eisen kennedy johnson nixon ford carter reagan bush y1983 if year< 1996
poisson counpma wek2twn divided war unemploy truman eisen kennedy johnson nixon ford carter reagan bush y1983 if year< 1996
lrtest, saving (4)
poisson counpma wek2twn divided war unemploy y1983
lrtest, using (4)
*Note the chi square from the first model and the df.
*Note the results of the lrtest and also note the key fixed effects from the firts model.
more

nbreg counpma weaktwn divided war unemploy truman eisen kennedy johnson nixon ford carter reagan bush y1983 if year< 1996 
more

*Now with distance measures instead of divided government
poisson counesec weaktwn prdist war unemploy truman eisen kennedy johnson nixon ford carter reagan bush if year< 1996
more
*Now with different definitions of the dependent variable
poisson counpma weaktwn divided y1983 truman eisen kennedy johnson nixon ford carter reagan bush if year< 1996, robust
poisson counsec weaktwn divided truman eisen kennedy johnson nixon ford carter reagan bush if year< 1996, robust
poisson counexec weaktwn divided truman eisen kennedy johnson nixon ford carter reagan bush if year< 1996, robust
poisson counreor weaktwn divided truman eisen kennedy johnson nixon ford carter reagan bush if year< 1984, robust
poisson counleg weaktwn divided truman eisen kennedy johnson nixon ford carter reagan bush if year<1996, robust

more

*Now using the second weakness measure which includes party difference
poisson counesec wek2twn divided war unemploy truman eisen kennedy johnson nixon ford carter reagan bush if year< 1996, robust
*note the chi square and df.  Note the important fixed effects.
more
poisson counesec wek2twn divided war unemploy truman eisen kennedy johnson nixon ford carter reagan bush if year< 1996
lrtest, saving (2)
poisson counesec wek2twn divided war unemploy 
lrtest, using (2)

*Note the chi square and df of the lrtest.  
more
nbreg counesec wek2twn divided war unemploy truman eisen kennedy johnson nixon ford carter reagan bush if year< 1996

*Now with ada measures.  Nothing is significant with this alternate measure.
generate stdhada_n=(std_h_a-31.91803)/2.208069
generate stdsada_n=(std_s_a-30.64333)/2.107417
generate chdfada_n=(ch_df_a-6.346531)/4.568365
generate mpdfada_n=(mp_df_a-13.79647)/19.9804

generate weak_ada=stdhada_n+stdsada_n+chdfada_n
generate weak2_ada=stdhada_n+stdsada_n+mpdfada_n

summarize weak_ada weak2_ada
more

generate weakada_n=(weak_ada-.0000000193)/2.08273
generate wek2ada_n=(weak2_ada-.0000000338)/2.316434

summarize weakada_n wek2ada_n

*Now using these measures
poisson counesec weakada_n divided war unemploy truman eisen kennedy johnson nixon ford carter reagan bush if year< 1996, robust
poisson counpma weakada_n divided war unemploy truman eisen kennedy johnson nixon ford carter reagan bush y1983 if year< 1996, robust
more
poisson counpma weakada_n adadist war unemploy truman eisen kennedy johnson nixon ford carter reagan bush if year< 1996, robust
poisson counesec weakada_n adadist war unemploy truman eisen kennedy johnson nixon ford carter reagan bush if year< 1996, robust
more
nbreg counesec weakada_n divided war unemploy truman eisen kennedy johnson nixon ford carter reagan bush if year< 1996, robust
more


poisson counesec wek2ada_n divided war unemploy truman eisen kennedy johnson nixon ford carter reagan bush if year< 1996, robust
poisson counpma wek2ada_n divided war unemploy truman eisen kennedy johnson nixon ford carter reagan bush y1983 if year< 1996, robust
more
poisson counpma wek2ada_n adadist war unemploy truman eisen kennedy johnson nixon ford carter reagan bush if year< 1996, robust
poisson counesec wek2ada_n adadist war unemploy truman eisen kennedy johnson nixon ford carter reagan bush if year< 1996, robust
more
nbreg counesec wek2ada_n divided war unemploy truman eisen kennedy johnson nixon ford carter reagan bush if year< 1996, robust

more
*What comes next is the logit models.
more

clear
* We use agency data from Lewis (2000/2003) where each observation is an agency created between 1946-1997 rather than a year.  Each
*agency is coded according to how it was created, either by legislation or executive action.

use wpsaagency
*This next section uses the agency data set to estimate the logit models in Table 2.

*First we have to create some of the same variables that were in the last analysis.
*Difference in common space scores.
generate prdist=abs(cspres-cshmed)

*A dummy for post 1983 to account for the Chadha decision.
generate y1983=1 if year>1983
replace y1983=0 if year<1984

*First, create the measure of weakness.  We take the standard deviation of the d-nom
*scores for the house and senate and normalize them by subtracting the mean and dividing
*by the standard deviation.  We do the same for the chamber difference and majority party
*chamber difference measures.

generate stdhdn_n=(std_h_dn-.2668735)/.0122553
generate stdsdn_n=(std_s_dn-.3151008)/.0091165
generate chdftw_n=(ch_df_tw-.06132)/.0373917
generate mpdftw_n=(mp_df_tw-.12392)/.1425259

*We then sum these measures to calculate a weakness measure.  The larger this value, the
*weaker congress is.

generate weak_tw=stdhdn_n+stdsdn_n+chdftw_n
generate weak2_tw=stdhdn_n+stdsdn_n+mpdftw_n

*The two weakness measures transformed to vary between 0 and 1.
generate wek2twn=(weak2_tw+abs(-2.711068))/abs(4.019769-(-2.711068))
generate weaktwn=(weak_tw+abs(-3.296163))/(5.877523-(-3.296163))

*Now with ada measures.
generate stdhada_n=(std_h_a-31.91803)/2.208069
generate stdsada_n=(std_s_a-30.64333)/2.107417
generate chdfada_n=(ch_df_a-6.346531)/4.568365
generate mpdfada_n=(mp_df_a-13.79647)/19.9804

generate weak_ada=stdhada_n+stdsada_n+chdfada_n
generate weak2_ada=stdhada_n+stdsada_n+mpdfada_n

summarize weak_ada weak2_ada
more

generate weakada_n=(weak_ada-.0000000193)/2.08273
generate wek2ada_n=(weak2_ada-.0000000338)/2.316434

summarize weakada_n wek2ada_n


*Ok, now to the models.  Pmade is an indicator (0,1) for whether the agency was created by executive action (1) or statute (0).

logit pmade wek2twn divided war unemploy y1983 truman eisen kennedy johnson nixon ford carter reagan bush if year<1996

*Note the chi-square and note the important fixed effects, their coefficients and standard errors.

more
logit pmade wek2twn divided war unemploy y1983 truman eisen kennedy johnson nixon ford carter reagan bush if year<1996
lrtest, saving (1)
logit pmade wek2twn divided war unemploy y1983 if year<1996

lrtest, using (1)
*Note the lr test for the importance of the fixed effects.  Note the important fixed effects.
more
logit pmade weaktwn divided war unemploy y1983 truman eisen kennedy johnson nixon ford carter reagan bush if year<1996
lrtest, saving (5)
logit pmade weaktwn divided war unemploy y1983 if year<1996

lrtest, using (5)
*Note the chi square and note the lrtest and the important fixed effects.
more
logit pmade wek2twn prdist war unemploy y1983 truman eisen kennedy johnson nixon ford carter reagan bush if year<1996
logit pmade weaktwn prdist war unemploy y1983 truman eisen kennedy johnson nixon ford carter reagan bush if year<1996
more
*Note the following chi square test
logit pmade wek2twn divided war unemploy truman eisen kennedy johnson nixon ford carter reagan bush if reorg==0 &year<1996
lrtest, saving (6)
logit pmade wek2twn divided war unemploy if reorg==0 &year<1996

lrtest, using (6)
more
*Note the following chi square test
logit pmade weaktwn divided war unemploy truman eisen kennedy johnson nixon ford carter reagan bush if reorg==0 &year<1996
lrtest, saving (7)
logit pmade weaktwn divided war unemploy if reorg==0 &year<1996

lrtest, using (7)
more
logit pmade wek2twn prdist war unemploy truman eisen kennedy johnson nixon ford carter reagan bush if reorg==0 &year<1996
more
logit pmade weaktwn prdist war unemploy truman eisen kennedy johnson nixon ford carter reagan bush if reorg==0&year<1996


