***********************************************************************************************************
*Name: Nick Gallo and David E. Lewis
*Project: Patronage Appointees and Performance
*Date: July 23, 2009
*Summary: This batch file is intended to read into STATA the PART program scores and conduct the analyses
*necessary for the tables in Gallo and Lewis 2009.
*Data Notes: This is for Complete_PART_Score_Data 122109.xls. Note in this data that PARTgood is a function
*of the cutoff used to decide whether the PART scores were reliable. 250 is a cutoff where at least 50
*percent of respondents thought part scores were sometimes reliable or above. 667 is 2/3 thought sometimes
*reliable or above. 375 is 75% thought sometimes reliable or above. The stricter the cutoff, the fewer
*the number of managers with campaign connections.
***********************************************************************************************************

*I need to create some variables for campaign work. There are 11 appointees that worked on the campaign by
*different measures.

generate education=0 if levelofeducation~=""
replace education=1 if levelofeducation=="B.A."
replace education=1 if levelofeducation=="B.S."
replace education=1 if levelofeducation=="USMA"
replace education=1 if levelofeducation=="USNA"
replace education=2 if levelofeducation=="C.P.A."
replace education=2 if levelofeducation=="J.D."
replace education=2 if levelofeducation=="M.A."
replace education=2 if levelofeducation=="M.B.A."
replace education=2 if levelofeducation=="M.F.A."
replace education=2 if levelofeducation=="M.P.A."
replace education=2 if levelofeducation=="M.S."
replace education=3 if levelofeducation=="D.D.S."
replace education=3 if levelofeducation=="M.D."
replace education=4 if levelofeducation=="P.H.D"
replace education=4 if levelofeducation=="Ph.D."
replace education=4 if levelofeducation=="PH.D."
replace education=4 if levelofeducation=="Sc.D."

more

tab education, generate(ed)
replace ed3=1 if ed4==1
replace ed4=ed5

generate tenure=tenureasbu if tenureasb<20

*Now generate appointee variables
generate careerist=0
replace careerist =1 if typeofmanager=="CA"

generate appointee=0
replace appointee=1 if careerist==0&typeofmanager~="XS"

generate NA=0
replace NA=1 if typeofmanager=="NA"

generate PAS=0
replace PAS=1 if typeofmanager=="PAS"

generate XS=0
replace XS=1 if typeofmanager=="XS"

*Now program type
tab type1 if type1~="Mixed", generate(t)

*Now budget size
generate lnbudg=ln(actual)

*Now year dummies
tab yearassessed, generate(y)

*Now agency ideology
generate conservative=0 if mean~=.
replace conservative=1 if var2>0&var3>0

generate liberal=0 if mean~=.
replace liberal=1 if var2<0&var3<0

*Now I need to create a variable for programs with no bureau list.

generate nobureau1=0
replace nobureau1=1 if agencyname==bureau
replace nobureau1=1 if bureau==""

*now last job in government
generate government=0
replace government=1 if previousjob=="Government"

*Appointee from campaign
generate campapp=0
replace campapp=1 if appointee==1&workedforcampaign==1

*Campaign contribution
generate contribution2=0 if presidentialcontribution~=.
replace contribution2=contributionamount if presidentialcontribution==1

*Generate patronage combining work for party or work on campaign
generate patronage=0
replace patronage=1 if workedforparty==1|campapp==1


**Table 2 Analyses of Patronage
reg total appointee campapp lnbudg t1-t6 termli comi ofprog mean y2-y7 if XS==0
hettest
more
rvfplot, yline(0)
more
predict rstud2, rstudent
stem rstud2
summarize rstud2, detail
more
kdensity rstud2, normal
more
lvr2plot, mlabel(mgrid)
more
avplots
more

reg total appointee campapp lnbudg t1-t6 termli comi ofprog mean y2-y7 if XS==0, robust
test y2=y3=y4=y5=y6=y7=0

reg total appointee patronage lnbudg t1-t6 termli comi ofprog mean y2-y7 if XS==0, robust
test y2=y3=y4=y5=y6=y7=0

reg total appointee campapp lnbudg t1-t6 termli comi ofprog mean y2-y7 if XS==0&partgood250==1, robust
test y2=y3=y4=y5=y6=y7=0

reg total appointee patronage lnbudg t1-t6 termli comi ofprog mean y2-y7 if XS==0&partgood250==1, robust
test y2=y3=y4=y5=y6=y7=0


Table 3. 
reg total appointee lncamp lnbudg t1-t6 termli comi ofprog mean y2-y7 if XS==0, robust
reg total appointee lncamp lnbudg t1-t6 termli comi ofprog mean y2-y7 if XS==0&partgood250==1, robust
reg total appointee lncamp lnbudg t1-t6 termli comi ofprog mean y2-y7 if XS==0&secretary==0, robust
reg total appointee lncamp lnbudg t1-t6 termli comi ofprog mean y2-y7 if XS==0&partgood250==1&secretary==0, robust


Table 4. Background characteristics and program performance.

reg total previousagency tenure public ed3 ed4 experienceina private workedinwhite workedincongre lnbud t1-t6 terml comi ofprograms mean y1-y6 if XS==0, robust
test y1=y2=y3=y4=y5=y6=0
reg total previousagency tenure public ed3 ed4 experienceina private workedinwhite workedincongre lnbud t1-t6 terml comi ofprograms mean y1-y6 if XS==0&partgood250==1&secretary==0, robust
test y1=y2=y3=y4=y5=y6=0
more


***ROBUSTNESS CHECKS IN ORDER APPEAR IN THE PAPER***

**Now without some outlier possibilities based upon lvr2plots--232, 403 [FOOTNOTE]
reg total appointee campapp lnbudg t1-t6 termli comi ofprog mean y2-y7 if XS==0&mgrid~=232&mgrid~=403, robust
reg total appointee patronage lnbudg t1-t6 termli comi ofprog mean y2-y7 if XS==0&mgrid~=232&mgrid~=403, robust
reg total appointee campapp lnbudg t1-t6 termli comi ofprog mean y2-y7 if XS==0&partgood250==1&mgrid~=232&mgrid~=403, robust
reg total appointee patronage lnbudg t1-t6 termli comi ofprog mean y2-y7 if XS==0&partgood250==1&mgrid~=232&mgrid~=403, robust
reg total previousagency tenure public ed3 ed4 experienceina private workedinwhite workedincongre lnbud t1-t6 terml comi ofprograms mean if XS==0&partgood250==1&mgrid~=232&mgrid~=403, robust

**Excluding cases with no bureau listed [APPENDIX A]
reg total appointee campapp lnbudg t1-t6 termli comi ofprog mean y2-y7 if XS==0&nobureau==0, robust
reg total appointee patronage lnbudg t1-t6 termli comi ofprog mean y2-y7 if XS==0&nobureau==0, robust
reg total appointee campapp lnbudg t1-t6 termli comi ofprog mean y2-y7 if XS==0&partgood250==1&nobureau==0, robust
reg total appointee patronage lnbudg t1-t6 termli comi ofprog mean y2-y7 if XS==0&partgood250==1&nobureau==0, robust
reg total previousagency tenure public ed3 ed4 experienceina private workedinwhite workedincongre lnbud t1-t6 terml comi ofprograms mean if XS==0&partgood250==1&nobureau==0, robust

**Including XS Cases [FOOTNOTE]
reg total appointee campapp lnbudg t1-t6 termli comi ofprog mean y2-y7 XS if partgood250==1, robust
reg total appointee patronage lnbudg t1-t6 termli comi ofprog mean y2-y7 XS if partgood250==1, robust
reg total previousagency tenure public ed3 ed4 experienceina private workedinwhite workedincongre lnbud t1-t6 terml comi ofprograms mean XS if partgood250==1, robust

**Fixed effects for department [APPENDIX A]
tab depid, generate(d)
reg total appointee campapp lnbudg t1-t6 termli comi ofprog mean y2-y7 d12-d26 if XS==0&partgood250==1, robust
reg total appointee patronage lnbudg t1-t6 termli comi ofprog mean y2-y7 d12-d26 if XS==0&partgood250==1, robust
reg total previousagency tenure public ed3 ed4 experienceina private workedinwhite workedincongre lnbud t1-t6 terml comi ofprograms mean d12-d26 if XS==0&partgood250==1, robust

**Manager as unit of analysis [below]

**Oprobit--Overall Rating [APPENDIX A]
oprobit ratingnum appointee campapp lnbudg t1-t6 termli comi ofprog mean y2-y7 if XS==0&partgood250==1, robust
oprobit ratingnum appointee patronage lnbudg t1-t6 termli comi ofprog mean y2-y7 if XS==0&partgood250==1, robust
oprobit ratingnum previousagency tenure public ed3 ed4 experienceina private workedinwhite workedincongre lnbud t1-t6 terml comi ofprograms mean if XS==0&partgood250==1, robust

**Cluster on bureau  [FOOTNOTE]
reg total appointee campapp lnbudg t1-t6 termli comi ofprog mean y2-y7 if XS==0&partgood250==1, cluster(burid)
reg total appointee patronage lnbudg t1-t6 termli comi ofprog mean y2-y7 if XS==0&partgood250==1, cluster(burid)
reg total previousagency tenure public ed3 ed4 experienceina private workedinwhite workedincongre lnbud t1-t6 terml comi ofprograms mean if XS==0&partgood250==1, cluster(burid)

**Cluster on manager [FOOTNOTE]
reg total appointee campapp lnbudg t1-t6 termli comi ofprog mean y2-y7 if XS==0&partgood250==1, cluster(mgrid)
reg total appointee patronage lnbudg t1-t6 termli comi ofprog mean y2-y7 if XS==0&partgood250==1, cluster(mgrid)
reg total previousagency tenure public ed3 ed4 experienceina private workedinwhite workedincongre lnbud t1-t6 terml comi ofprograms mean if XS==0&partgood250==1, cluster(mgrid)


**DIFFERENT CUTOFFS [FOOTNOTE]

ttest total if XS==0&partgood3667==1, by(campapp)
ttest total if XS==0&partgood3667==1, by(patronage)

ttest total if XS==0&partgood375==1&appointee==1, by(campapp)
ttest total if XS==0&partgood375==1&appointee==1, by(patronage)

**INCLUDING THE TENURE OF THE MANAGER [Memo to Editor]
reg total appointee campapp lnbudg t1-t6 termli comi ofprog mean y2-y7 tenure if XS==0, robust
test y2=y3=y4=y5=y6=y7=0

reg total appointee patronage lnbudg t1-t6 termli comi ofprog mean y2-y7 tenure if XS==0, robust
test y2=y3=y4=y5=y6=y7=0

reg total appointee campapp lnbudg t1-t6 termli comi ofprog mean y2-y7 tenure if XS==0&partgood250==1, robust
test y2=y3=y4=y5=y6=y7=0

reg total appointee patronage lnbudg t1-t6 termli comi ofprog mean y2-y7 tenure if XS==0&partgood250==1, robust
test y2=y3=y4=y5=y6=y7=0


**Now 2SLS for appointee regressions [APPENDIX A]
generate secterm=0
replace secterm=1 if yearassessed>2004
generate firstyear=0
replace firstyear=1 if dateofhire==2001|dateofhire==2005
generate ty1=y4
generate ty2=y1
replace ty2=1 if y5==1
generate ty3=y2
replace ty3=1 if y6==1
generate ty4=y3
replace ty4=1 if y7==1
generate termyear=1 if ty1==1
replace termyear=2 if ty2==1
replace termyear=3 if ty3==1
replace termyear=4 if ty4==1

ivregress 2sls total (appointee patronage =firstyear termyear secterm ) lnbudg t1-t6 termli comi ofprog mean if XS==0&partgood250==1&y1==0, robust
estat endogenous
estat overid

ivregress 2sls total (patronage =firstyear termyear secterm ) lnbudg t1-t6 termli comi ofprog mean if XS==0&partgood250==1&y1==0&appointee==1, robust
estat endogenous
estat overid

reg appointee firstyear termyear secterm lnbudg t1-t6 termli comi ofprog mean if XS==0&partgood250==1&y1==0, robust
predict app_hat

reg patronage firstyear termyear secterm lnbudg t1-t6 termli comi ofprog mean if XS==0&partgood250==1&y1==0, robust
predict pat_hat

reg total appointee patronage lnbudg t1-t6 termli comi ofprog mean y2-y7 app_hat pat_hat if XS==0&partgood250==1, robust
test app_hat=pat_hat=0

**Now with liberal and conservative agencies estimated separately. [APPENDIX A]
**I estimate these with fewer program and year specific controls because of few cases and many cells have a limited number of cases. For example there are only 2 agencies where t4==1 in the liberal agencies model.
**I keep these estimates here to show that the results are more or less the same.

reg total appointee campapp lnbudg t1-t6 termli comi ofprog mean y2-y7 if XS==0&liberal==1&partgood250==1, robust
reg total appointee campapp lnbudg t1-t6 termli comi ofprog mean y2-y7 if XS==0&conservative==1&partgood250==1, robust
reg total appointee patronage lnbudg t1-t6 termli comi ofprog mean y2-y7 if XS==0&liberal==1&partgood250==1, robust
reg total appointee patronage lnbudg t1-t6 termli comi ofprog mean y2-y7 if XS==0&conservative==1&partgood250==1, robust

reg total appointee patronage lnbudg ofprog mean if XS==0&liberal==1&partgood250==1, robust
reg total appointee patronage lnbudg ofprog mean if XS==0&conservative==1&partgood250==1, robust


**Now with tenure squared. [FOOTNOTE]
generate tenuresq=tenure^2
reg total previousagency tenure tenuresq public ed3 ed4 experienceina private workedinwhite workedincongre lnbud t1-t6 terml comi ofprograms mean y1-y6 if XS==0, robust
reg total previousagency tenure tenuresq public ed3 ed4 experienceina private workedinwhite workedincongre lnbud t1-t6 terml comi ofprograms mean y1-y6 if XS==0&partgood250==1, robust

**Now 2SLS for tenure regressions.
ivregress 2sls total previousagency (tenure = yearassessed dateofhire) public ed3 ed4 experienceina private workedinwhite workedincongre lnbud t1-t6 terml comi ofprograms mean if XS==0&partgood250==1&y1==0, first robust
estat endogenous

reg tenure yearassessed dateofhire public ed3 ed4 experienceina private workedinwhite workedincongre lnbud t1-t6 terml comi ofprograms mean if XS==0&partgood250==1&y1==0, robust
predict tenure_hat

reg total tenure_hat previousagency tenure public ed3 ed4 experienceina private workedinwhite workedincongre lnbud t1-t6 terml comi ofprograms mean if XS==0&partgood250==1&y1==0, robust

more

**Without secretaries. Excludes all programs listed as being run by secretaries.
reg total appointee campapp lnbudg t1-t6 termli comi ofprog mean y2-y7 if XS==0 &secretary==0, robust
reg total appointee patronage lnbudg t1-t6 termli comi ofprog mean y2-y7 if XS==0 &secretary==0, robust
reg total appointee campapp lnbudg t1-t6 termli comi ofprog mean y2-y7 if XS==0 &secretary==0&partgood250==1, robust
reg total appointee patronage lnbudg t1-t6 termli comi ofprog mean y2-y7 if XS==0 &secretary==0&partgood250==1, robust
reg total previousagency tenure public ed3 ed4 experienceina private workedinwhite workedincongre lnbud t1-t6 terml comi ofprograms mean if XS==0&partgood250==1&secretary==0, robust

**MANAGER AS UNIT OF ANALYSIS

collapse (mean) total  appointee campapp patronage lncamp previousagency tenure public experienceina education ed3 ed4 private workedinwhite workedincongre lnbud t1-t7 terml comi ofprograms mean PAS NA depid uburid secretary if partgood250==1&XS==0, by(mgrid)

reg total appointee campapp lnbudg t1-t6 termli comi ofprog mean

reg total appointee patronage lnbudg t1-t6 termli comi ofprog mean

hettest
more
rvfplot, yline(0)
more
predict rstud3, rstudent
stem rstud3
summarize rstud3, detail
more
kdensity rstud3, normal
more
lvr2plot, mlabel(mgrid)
more
avplots
more

reg total appointee lncamp lnbudg t1-t6 termli comi ofprog mean

reg total previousagency tenure public ed3 ed4 experienceina private workedinwhite workedincongre lnbud t1-t6 terml comi ofprograms mean


**MANAGER SUMMARY STATISTICS FOR TESTING STATISTICAL DIFFERENCES
**FOR SOME DATA HAVE TO RELY ON RESUME COMPILATION 8 28 09.XLS

collapse (mean) total section1 section2 section3 section4 var1 appointee campapp patronage lncamp previousagency tenure public experienceina education ed3 ed4 private workedinwhite workedincongre lnbud t1-t7 terml comi ofprograms mean PAS NA depid uburid secretary if XS==0, by(mgrid)

**Now whether other appointees statistically distinguishable from careerists
ttest education if campapp==0& appointee==0|appointee==1, by(appointee)
ttest previousa if campapp==0& appointee==0|appointee==1, by(appointee)
ttest experience if campapp==0& appointee==0|appointee==1, by(appointee)
ttest public if campapp==0& appointee==0|appointee==1, by(appointee)
ttest private if campapp==0& appointee==0|appointee==1, by(appointee)
ttest tenure if campapp==0& appointee==0|appointee==1, by(appointee)
ttest workedinc if campapp==0& appointee==0|appointee==1, by(appointee)
ttest workedinwh if campapp==0& appointee==0|appointee==1, by(appointee)
ttest ofprogram if campapp==0& appointee==0|appointee==1, by(appointee)
ttest var1 if campapp==0& appointee==0|appointee==1, by(appointee)
ttest section1 if campapp==0& appointee==0|appointee==1, by(appointee)
ttest section2 if campapp==0& appointee==0|appointee==1, by(appointee)
ttest section3 if campapp==0& appointee==0|appointee==1, by(appointee)
ttest section4 if campapp==0& appointee==0|appointee==1, by(appointee)
ttest total if campapp==0& appointee==0|appointee==1, by(appointee)

**Now whether patronage appointees are different from other appointees.
ttest education if appointee==1, by(campapp)
ttest previousa if appointee==1, by(campapp)
ttest experience if appointee==1, by(campapp)
ttest public if appointee==1, by(campapp)
ttest private if appointee==1, by(campapp)
ttest tenure if appointee==1, by(campapp)
ttest workedinc if appointee==1, by(campapp)
ttest workedinwh if appointee==1, by(campapp)
ttest ofprogram if appointee==1, by(campapp)
ttest var1 if appointee==1, by(campapp)
ttest section1 if appointee==1, by(campapp)
ttest section2 if appointee==1, by(campapp)
ttest section3 if appointee==1, by(campapp)
ttest section4 if appointee==1, by(campapp)
ttest total if appointee==1, by(campapp)



**Now whether patronage appointees are different from other appointees with the other measure.
ttest education if appointee==1, by(patronage)
ttest previousa if appointee==1, by(patronage)
ttest experience if appointee==1, by(patronage)
ttest public if appointee==1, by(patronage)
ttest private if appointee==1, by(patronage)
ttest tenure if appointee==1, by(patronage)
ttest workedinc if appointee==1, by(patronage)
ttest workedinwh if appointee==1, by(patronage)
ttest ofprogram if appointee==1, by(patronage)
ttest var1 if appointee==1, by(patronage)
ttest section1 if appointee==1, by(patronage)
ttest section2 if appointee==1, by(patronage)
ttest section3 if appointee==1, by(patronage)
ttest section4 if appointee==1, by(patronage)

ttest education if campapp==1& appointee==1|appointee==0, by(appointee)
ttest previousa if campapp==1& appointee==1|appointee==0, by(appointee)
ttest experience if campapp==1& appointee==1|appointee==0, by(appointee)
ttest public if campapp==1& appointee==1|appointee==0, by(appointee)
ttest private if campapp==1& appointee==1|appointee==0, by(appointee)
ttest tenure if campapp==1& appointee==1|appointee==0, by(appointee)
ttest workedinc if campapp==1& appointee==1|appointee==0, by(appointee)
ttest workedinwh if campapp==1& appointee==1|appointee==0, by(appointee)
ttest ofprogram if campapp==1& appointee==1|appointee==0, by(appointee)
ttest var1 if campapp==1& appointee==1|appointee==0, by(appointee)
ttest section1 if campapp==1& appointee==1|appointee==0, by(appointee)
ttest section2 if campapp==1& appointee==1|appointee==0, by(appointee)
ttest section3 if campapp==1& appointee==1|appointee==0, by(appointee)
ttest section4 if campapp==1& appointee==1|appointee==0, by(appointee)
ttest total if campapp==1& appointee==1|appointee==0, by(appointee)

