*---------------------------------------------------------------------------------------------
*
*By:  John B. Gilmour and David E. Lewis
*Date: July 26, 2004
*
*My hope is to read data into stata, combine it with information from FY2005
*----------------------------------------------------------------------------------------------
*First, I need to do some housekeeping.
set memory 64000
set l 72
set level 95
set matsize 150

use cohort1jpart.dta
joinby programid using cohort1jpartfy2005scores.dta
summarize

*Here are a series of change variables that are useful.
generate partchange=totalweightedd2005-totalweighted
generate gradechange=totalratingd2005-programgrade
generate budgetchange=fy2005estimated2005-fy2004estimated2005
generate pctbudchange=(budgetchange/fy2004estimated2005)*100
generate bchangefrom2003act=fy2005estimated2005-fy2003actual
generate pbchangefrom2003act=bchangefrom2003act/fy2003actual
summarize budgetchange partchange gradechange pctbudchange bchangefrom2003act pbchangefrom2003act

generate departmentid3=departmentid2
replace departmentid3=4 if departmentid2==3
replace departmentid3=departmentid3-1 if departmentid3>3
tab departmentid3, generate (dep)

*Now some budget variables.

*The following creates two variables, budget1 and budget2, that
*calculate the percentage growth in budgets from FY2002-FY2003 
*and FY2003-FY2004.  Then it creates two more variables, newbud1 and 
*newbud2 that are the same except that they code as missing values cases 
*in which the change in the budget is more than 50% in one year.  
generate budget0203=(fy2003v2-fy2002v2)/fy2002v2*100
generate budget0304=(fy2004v2-fy2003v2)/fy2003v2*100
generate newbud0203=.
generate newbud0304=.
replace newbud0203=budget0203 if budget0203 >-50  & budget0203<50
replace newbud0304=budget0304 if budget0304 >-50  & budget0304 <50


generate ln2003=ln(fy2003actual) if fy2003actual>0
generate lastbudch=((fy2004estimated2005-fy2003actual)/fy2003actual)*100
generate lastotal=totalweighted*lastbudch

summarize ln2003 lastbudch
more

*Now program dummies.
replace programtype1="Capital Assets and Service Acquisition" if programid==179
tab programtype1, generate(prog)
tab programtype2, generate(secprog)
tab programtype3, generate(thirdprog)

list programtype2 if secprog1==1
list programtype2 if secprog2==1
list programtype2 if secprog3==1

list programtype3 if thirdprog1==1

replace prog2=1 if thirdprog1==1
replace prog3=1 if secprog1==1
replace prog5=1 if secprog3==1
replace prog7=1 if secprog2==1

*I am going to add a few more dates collected by Gilmour.  We have a few concerns since some programs are administered
*in a different format than the were at their start.  The maternal child and health block grant is an example.

replace year=1938 if programid==105
replace year=1980 if programid==113
replace year=1996 if programid==115|programid==120|programid==162
replace year=1921 if programid==117
replace year=1935 if programid==119
replace year=1944 if programid==122
replace year=1965 if programid==126
replace year=1990 if programid==140
replace year=1992 if programid==158
replace year=1973 if programid==230

joinby year using gilmourtv, unmatched(master)

*The following commands create a dummy variable "demdept" that is coded 1 
*for departments associated with the Democratic party, and departments that 
*the Republican party has sought to eliminate: HUD, HHS, Education, 
*Commerce, EPA, Energy, Labor.  All other departments are coded zero. 
generate demdept=0
replace demdept=1 if departmentid==2
replace demdept=1 if departmentid==5
replace demdept=1 if departmentid==6
replace demdept=1 if departmentid==7
replace demdept=1 if departmentid==8
replace demdept=1 if departmentid==10
replace demdept=1 if departmentid==13

*These commands crate a variable called "control." It is coded 1 for 
*unified Democratic control, -1 for unified Republican control, and 0 
*for divided control.  
generate control=0 
replace control=1 if dempres==1 & demsen==1 & demhouse==1
replace control=-1 if dempres==0 & demsen==0 & demhouse==0

*Now I will generate a variable for unified democratic congress and unified control.
generate demcong=demhouse*demsen
generate unified=0
replace unified=1 if divided==0
generate unidem=demcong*unified

**Now I will generate a variable for entitlement-type programs
generate entitle=0
replace entitle=1 if programid==2|programid==3|programid==9|programid==63|programid==84|programid==85|programid==114|programid==127|programid==137|programid==193|programid==199|programid==202|programid==203|programid==222
list program if entitle==1

*These commands create a variable sizecategory in which 1 
*is for small programs (under $75 million), 2 is medium (75-500 million), 
*and 3 is large (over 500 million). 
generate sizecategory=0 
replace sizecategory=1 if fy2004estimated2005<=75 
replace sizecategory=2 if fy2004estimated2005>75 & fy2004estimated2005<=500 
replace sizecategory=3 if fy2004estimated2005>500 
generate small=0 
generate medium=0 
generate large=0 
replace small=1 if fy2004estimated2005<=75 
replace medium=1 if fy2004estimated2005>75 & fy2004estimated2005<=500 
replace large=1 if fy2004estimated2005>500 
generate smtot=small*totalweightedd2005
generate medtot=medium*totalweightedd2005
generate lartot=large*totalweightedd2005


**Now program pupose change.
generate purpch=progrpurpd2005-programpurposeraw

hist budget0304, xtitle(Percentage Change in FY 2003 to FY 2004 Budget Request) t1("First Cohort of Federal Programs Graded, FY 2004 Data") bin(15)
more
hist budget0304 if budget0304>-101&budget0304<101, xtitle(Percentage Change in FY 2003 to FY 2004 Budget Request) t1("First Cohort of Federal Programs Graded, FY 2004 Data") bin(15)
more

*These are the two top graphs in Figure 2.
hist pctbud, xtitle(Percentage Change in FY 2004 to FY 2005 Budget Request) t1("First Cohort of Programs Graded, FY 2005 Data") bin(15)
more
hist pctbud if pctbud>-101&pctbud<101, xtitle(Percentage Change in FY 2004 to FY 2005 Budget Request) t1("First Cohort of Programs Graded, FY 2005 Data") bin(15)
more

twoway lfit budget0304 totalweighted, t1("FY 2004 Budget") xtitle("Total Weighted Part Score") ytitle("Change in Program Budget FY 2003 to FY 2004")||scatter budget0304 totalweighted, legend(off)

*This is the first graph in Figure 3
twoway lfit pctbud totalweightedd2005 if pctbud>-101&pctbud<101, t1("Cohort 1") xtitle("Total Weighted Part Score") ytitle("Change in Program Budget FY 2004 to FY 2005")||scatter pctbud totalweightedd2005 if pctbud>-101&pctbud<101, legend(off)


*Table 1
reg budget0304 totalweighted budget0203 demdept prog1-prog3 prog5 prog7-prog8 if entitle==0&budget0304>-101&budget0304<101, robust
reg budget0304 totalweighted budget0203 demdept control duration prog1-prog3 prog5 prog7-prog8 if entitle==0&budget0304>-101&budget0304<101, robust
more
reg pctbud totalweightedd2005 budget0203 demdept prog1-prog3 prog5 prog7-prog8 if entitle==0&pctbud>-101&pctbud<101, robust
reg pctbud totalweightedd2005 budget0203 demdept control duration prog1-prog3 prog5 prog7-prog8 if entitle==0&pctbud>-101&pctbud<101, robust
more


**Now the with measures cutting off at 50%.
*reg newbud0304 totalweighted newbud0203 demdept prog1-prog3 prog5 prog7-prog8 if entitle==0, robust
*reg newbud0304 totalweighted newbud0203 demdept control duration prog1-prog3 prog5 prog7-prog8 if entitle==0&year~=., robust



**Note:  The coefficients on totalweighted actually much bigger when all data included.  Coefficients on last year's budget go negative and significant
** in some cases.  The demdept variable becomes insignificant.  Control stays negative and insignificant.

more
*Table 2
reg pctbud totalweighted partch budget0203 demdept prog1-prog3 prog5 prog7-prog8 if entitle==0&pctbud>-101&pctbud<101, robust
reg pctbud totalweighted partch budget0203 demdept control duration prog1-prog3 prog5 prog7-prog8 if entitle==0&pctbud>-101&pctbud<101, robust
reg pctbud totalweighted partch budget0203 control duration prog1-prog3 prog5 prog7-prog8 if entitle==0&pctbud>-101&pctbud<101&demdept==1, robust
reg pctbud totalweighted partch budget0203 control duration prog1-prog3 prog5 prog7-prog8 if entitle==0&pctbud>-101&pctbud<101&demdept==0, robust

*Now with instrumental variables using political appointee head, commission, fixed term as exogenous predictors of PART.
ivreg pctbud totalweighted partch budget0203 demdept control duration prog1-prog3 prog5 prog7-prog8 (totalweighted=pas2 com term) if entitle==0&pctbud>-101&pctbud<101, robust


*Table 3--[Note that there is an error in Table 3 in the published paper.  The table suggests that the estimates for
*both cohorts are for FY 2005 but the estimates in the table for cohort 1 are actually for FY 2004.  To get the estimates
*for FY 2005, uses the first command below.]
more

*It should either be the following
reg pctbud progrpurpd2005 planningd2005 managementd2005 resultsd2005 budget0203 demdept control duration prog1-prog3 prog5 prog7-prog8 if entitle==0&pctbud>-101&pctbud<101, robust
reg budget0304 programpurposeraw  strategicplanningraw  programmanagementraw  programresultsraw budget0203 demdept control duration prog1-prog3 prog5 prog7-prog8 if entitle==0&budget0304>-101&budget0304<101, robust


reg pctbud progrpurpd2005  budget0203 demdept control duration prog1-prog3 prog5 prog7-prog8 if entitle==0&pctbud>-101&pctbud<101, robust
reg pctbud resultsd2005 budget0203 demdept control duration prog1-prog3 prog5 prog7-prog8 if entitle==0&pctbud>-101&pctbud<101, robust
reg pctbud managementd2005 budget0203 demdept control duration prog1-prog3 prog5 prog7-prog8 if entitle==0&pctbud>-101&pctbud<101, robust
reg pctbud planningd2005  budget0203 demdept control duration prog1-prog3 prog5 prog7-prog8 if entitle==0&pctbud>-101&pctbud<101, robust

*Table 4
reg newbud0304 programpurposeraw newbud0203 demdept prog1-prog8 if entitle==0&programgrade==1&budget0304>-101&budget0304<101, robust
reg newbud0304 programpurposeraw newbud0203 demdept prog1-prog8 if entitle==0&programgrade~=1&budget0304>-101&budget0304<101, robust
more
reg newbud0304 programpurposeraw newbud0203 demdept control duration prog1-prog3 prog5 prog7 prog8 if entitle==0&programgrade==1&budget0304>-101&budget0304<101, robust
reg newbud0304 programpurposeraw newbud0203 demdept control duration prog1-prog3 prog5 prog7 prog8 if entitle==0&programgrade~=1&budget0304>-101&budget0304<101, robust
more
reg pctbud purpch programpurposeraw budget0203 demdept control duration prog1-prog3 prog5 prog7 prog8 if entitle==0&programgrade==1&pctbud>-101&pctbud<101, robust
reg pctbud purpch programpurposeraw budget0203 demdept control duration prog1-prog3 prog5 prog7 prog8 if entitle==0&programgrade~=1&pctbud>-101&pctbud<101, robust
more

*Table 5
reg pctbud totalweightedd2005 budget0203 demdept prog1-prog3 prog5 prog7-prog8 if entitle==0&pctbud>-101&pctbud<101&small==1, robust
reg pctbud totalweightedd2005 budget0203 demdept prog1-prog3 prog5 prog7-prog8 if entitle==0&pctbud>-101&pctbud<101&medium==1, robust
reg pctbud totalweightedd2005 budget0203 demdept prog1-prog3 prog5 prog7-prog8 if entitle==0&pctbud>-101&pctbud<101&large==1, robust
reg pctbud totalweightedd2005 budget0203 demdept small smtot medium medtot prog1-prog3 prog5 prog7-prog8 if entitle==0&pctbud>-101&pctbud<101, robust

reg pctbud totalweightedd2005 budget0203 demdept control duration prog1-prog3 prog5 prog7-prog8 if entitle==0&pctbud>-101&pctbud<101&small==1, robust
reg pctbud totalweightedd2005 budget0203 demdept control duration prog1-prog3 prog5 prog7-prog8 if entitle==0&pctbud>-101&pctbud<101&medium==1, robust
reg pctbud totalweightedd2005 budget0203 demdept control duration prog1-prog3 prog5 prog7-prog8 if entitle==0&pctbud>-101&pctbud<101&large==1, robust
reg pctbud totalweightedd2005 budget0203 demdept control duration small smtot medium medtot prog1-prog3 prog5 prog7-prog8 if entitle==0&pctbud>-101&pctbud<101, robust



*These commands create a variable sizecategory in which 1 
*is for small programs (under $75 million), 2 is medium (75-500 million), 
*and 3 is large (over 500 million). I do this now for the FY2004 data.
generate scategory=0 
replace scategory=1 if fy2003v2<=75 
replace scategory=2 if fy2003v2>75 & fy2003v2<=500 
replace scategory=3 if fy2003v2>500 
generate ssmall=0 
generate smedium=0 
generate slarge=0 
replace ssmall=1 if fy2003v2<=75 
replace smedium=1 if fy2003v2>75 & fy2003v2<=500 
replace slarge=1 if fy2003v2>500 
generate ssmtot=ssmall*totalweighted
generate smedtot=smedium*totalweighted
generate slartot=slarge*totalweighted


reg budget0304 totalweighted budget0203 demdept prog1-prog3 prog5 prog7-prog8 if entitle==0&budget0304>-101&budget0304<101&ssmall==1, robust
reg budget0304 totalweighted budget0203 demdept prog1-prog3 prog5 prog7-prog8 if entitle==0&budget0304>-101&budget0304<101&smedium==1, robust
reg budget0304 totalweighted budget0203 demdept prog1-prog3 prog5 prog7-prog8 if entitle==0&budget0304>-101&budget0304<101&slarge==1, robust
reg budget0304 totalweighted budget0203 demdept ssmall ssmtot smedium smedtot prog1-prog3 prog5 prog7-prog8 if entitle==0&budget0304>-101&budget0304<101, robust

reg budget0304 totalweighted budget0203 demdept control duration prog1-prog3 prog5 prog7-prog8 if entitle==0&budget0304>-101&budget0304<101&ssmall==1, robust
reg budget0304 totalweighted budget0203 demdept control duration prog1-prog3 prog5 prog7-prog8 if entitle==0&budget0304>-101&budget0304<101&smedium==1, robust
reg budget0304 totalweighted budget0203 demdept control duration prog1-prog3 prog5 prog7-prog8 if entitle==0&budget0304>-101&budget0304<101&slarge==1, robust
reg budget0304 totalweighted budget0203 demdept control duration ssmall ssmtot smedium smedtot prog1-prog3 prog5 prog7-prog8 if entitle==0&budget0304>-101&budget0304<101, robust
