#################################################################
##  josh clinton
##  princeton university
##
##  Get roll call data for estimating the ideal points
##  Clinton, Jackman and Rivers: "The Most Liberal Senator"
#################################################################


#############################################################################
##  Dump Data for Simon's "Ideal" Analysis
##  Just National Journal Votes
#############################################################################

#   Order by time (Econ, Social, FP)
nj.key <- c(seq(27,1),seq(32,28),seq(60,62),seq(48,59),seq(43,47),seq(33,42))   # Create an index to collect votes together


#   Get Data
njkey<-read.table(file="C:/Documents and Settings/clinton/My Documents/Published Papers/CJR_PS2004/rollcall data/data.asc")
njkey<-as.matrix(njkey)


#   Resort ordering using nj.key
NJ<-njkey[,nj.key]

#   Tablulate abstention -- Basis of Table 1    
NJ[NJ==9]<-NA

poo<-apply(is.na(NJ),1,sum)/dim(NJ)[2]       #   Calculate Percent Missing

# Get name and party affiliation associated with voting profile

name <- scan(file="C:/Documents and Settings/clinton/My Documents/Published Papers/CJR_PS2004/name.asc",
                   what=list(name=""),
                   sep="\n")$name

cbind(name,poo)                             #   For Table 1       

ideal.output.1<-function(vote.m,m){                 #   Define a program for writing roll call data for use by ideal
    vote.m[is.na(vote.m)]<-9
    write(t(vote.m),file="C:/Documents and Settings/clinton/My Documents/ideal/Nat Journal/Key/src/data.asc",ncol=m)
    d <- t(apply(vote.m,1,function(x)x-mean(x,na.rm=T)))
    d <- apply(d,2,function(x)x-mean(x,na.rm=T))
    r <- cor(t(d),use="pairwise.complete.obs")
    r[r==Inf] <- 0
    r[is.na(r)] <- 0
    r[r==-Inf] <- 0
    e <- eigen(r)
    x.start<-round(e$vectors[,1]*3.7,digits=4)
    
    write(x.start,file="C:/Documents and Settings/clinton/My Documents/ideal/Nat Journal/Key/src/stvalx.asc",ncol=2)
}                                   

ideal.output.1(NJ,dim(njkey)[2])                   #    Execute the program

#   N = 100
#   M = 62


#############################################################################
##  Dump Data for Simon's "Ideal" Analysis
##  Include Bush as a Senator
##  National Journal Votes Only
#############################################################################

njkey<-read.table(file="C:/Documents and Settings/clinton/My Documents/Published Papers/CJR_PS2004/rollcall data/data.asc")
njkey<-as.matrix(njkey)
nj.key <- c(seq(27,1),seq(32,28),seq(60,62),seq(48,59),seq(43,47),seq(33,42))
NJB<-njkey[,nj.key]


#   Now include Bush's positions based on CQ vote reports -- the ordering is based on NJ.Key                                      
bush<-c(rep(NA,times=12),1,1,rep(NA,times=12),0,0,NA,1,NA,1,NA,NA,rep(1,times=6),NA,0,rep(1,times=5),NA,NA,NA,1,NA,1,NA,NA,1,1,NA,0,1,NA,NA)

NJ<-rbind(bush,NJB)     #   Include Bush's votes as the first row

                                      
ideal.output.1<-function(vote.m,m){
    
    vote.m[is.na(vote.m)]<-9
    write(t(vote.m),file="C:/Documents and Settings/clinton/My Documents/ideal/Nat Journal/KeyBush/src/data.asc",ncol=m)
    d <- t(apply(vote.m,1,function(x)x-mean(x,na.rm=T)))
    d <- apply(d,2,function(x)x-mean(x,na.rm=T))
    r <- cor(t(d),use="pairwise.complete.obs")
    r[r==Inf] <- 0
    r[is.na(r)] <- 0
    r[r==-Inf] <- 0
    e <- eigen(r)
    x.start<-round(e$vectors[,1]*3.7,digits=4)
    
    write(x.start,file="C:/Documents and Settings/clinton/My Documents/ideal/Nat Journal/KeyBush/src/stvalx.asc",ncol=2)
}                                   

ideal.output.1(NJ,dim(NJ)[2]) 

#   N = 101
#   M = 62

#############################################################################
##  Dump Data for Simon's "Ideal" Analysis
##  Include Bush as a Senator
##  All Senate 107 Votes
#############################################################################

sen107<-read.table(file="C:/Documents and Settings/clinton/My Documents/Published Papers/CJR_PS2004/rollcall data/sen107.R")
sen107<-as.matrix(sen107[,5:dim(sen107)[2]])

sen107[sen107==0]<-9
sen107<-sen107[-48,]    #   Drop Barkley
sen107[sen107==6]<-0

#   Drop unanimous votes
margin <- apply(sen107,2,
                function(x){
                  ok <- !is.na(x)
                  z <- c(sum(x[ok]==0),sum(x[ok]==1),sum(!ok))
                  z
                }
                )
margin <- t(margin)
totvot <- apply(margin,1,function(x)sum(x[1:2]))


## indicators for unaninimous

lop <- apply(margin,1,
             function(x){
               lop <- x[1]/totvot < .0001 | x[2]/totvot < .0001 
               lop
             }
             )
lop<-lop[1,]
sen107<-sen107[,!lop]

ideal.output.1<-function(vote.m,m){
    vote.m[is.na(vote.m)]<-9
    write(t(vote.m),file="C:/Documents and Settings/clinton/My Documents/ideal/Nat Journal/s107/src/data.asc",ncol=m)
    d <- t(apply(vote.m,1,function(x)x-mean(x,na.rm=T)))
    d <- apply(d,2,function(x)x-mean(x,na.rm=T))
    r <- cor(t(d),use="pairwise.complete.obs")
    r[r==Inf] <- 0
    r[is.na(r)] <- 0
    r[r==-Inf] <- 0
    e <- eigen(r)
    x.start<-round(e$vectors[,1]*-3.7,digits=4) 
    write(x.start,file="C:/Documents and Settings/clinton/My Documents/ideal/Nat Journal/s107/src/stvalx.asc",ncol=1)
}                                   

dim(sen107)     #   N=102, M=498
ideal.output.1(sen107,dim(sen107)[2])   
