/*********************************************************************	
	Scott Ashworth
	Josh Clinton
	Princeton University
	July 2006
	Code for "Does Advertising Affect Turnout?"
      National Sample
*********************************************************************/


/*  Get Data */

use "NationalData",replace
compress


log using "Table1", replace text
/********************/
/*  Table 1 Results */
/********************/

tabstat vote_2 if advrt==0		/*	Number in text	*/
tabstat vote_2 if advrt==1		/*	Number in text	*/


tabstat vote_2 advrt if bg==1	/*	Battleground Turnout and Exposure	*/
tabstat vote_2 advrt if bg==0	/*	Non-Battleground Turnout and Exposure	*/
table bg
log close


log using "Table2", replace text
/******************************************/
/*  Table 2 Results 		   		*/
/*  National Sample Wald Estimator		*/	
/******************************************/

/*	Number in Table is the coefficient for advrt	*/




/*  OLS		 */

reg vote_2 advrt, robust    				/*  	Full Sample -- Predicted Prob in text based on this */
reg vote_2 advrt if vote_1==0, robust		/*	"Non-voter" sample	*/
reg vote_2 advrt if vote_1==1, robust		/*	"Voter" sample	*/

gen iadvrt=vote_1*advrt					/*	Difference noted in text	*/
reg vote_2 advrt iadvrt vote_1, robust

/*  Wald Estimator */
ivreg vote_2 (advrt=bg), robust
ivreg vote_2 (advrt=bg) if vote_1==0, robust
ivreg vote_2 (advrt=bg) if vote_1==1, robust

/*  Calculate Hausman Tests for Each */
regress advrt bg 					/* Full Sample - F-stat in text from this*/	
predict res, resid 
regress vote_2 advrt res 
test res    					/*  Hausman Test */

regress advrt bg if vote_1==0 		/* "Non-Voters" */	
predict res1, resid 
regress vote_2 advrt res1 if vote_1==0
test res1   					/*  Hausman Test */

regress advrt bg if vote_1==1 		/* "Voters"	*/	
predict res2, resid
regress vote_2 advrt res2 if vote_1==1
test res2  						/*   Hausman Test */
log close

drop res res1 res2

log using "Table3", replace text
/******************************************************************/
/*	National Sample Characteristics by Battleground Status	*/
/*	Table 3 									*/
/******************************************************************/

sum if bg==0
sum if bg==1


/* Conduct T-tests for sample differences	*/
ttest vote_1, by(bg) unequal			/*	Pre-Campaign Vote Intention	*/
ttest vote_2, by(bg) unequal			/*	Post-Campaign Vote Intention	*/
ttest advrt, by(bg) unequal		/*	Advertising Exposure Indicator*/	
ttest pl_ntrst, by(bg) unequal		/*	Political Interest		*/
ttest strngth_, by(bg) unequal		/*	Strength of PID			*/
ttest age, by(bg) unequal			/*	Age					*/
ttest female, by(bg) unequal			/*	Female Indicator			*/
ttest hispanic, by(bg) unequal		/*	Hispanic Indicator		*/
ttest black, by(bg) unequal			/*	Balck Indicator			*/
ttest union, by(bg) unequal			/*	Union Indicator			*/
ttest church, by(bg) unequal			/*	Church Indicator			*/
ttest sen, by(bg) unequal			/*	Senate Race Indicator		*/
ttest gub, by(bg) unequal			/*	Gubernatorial Race Indicator	*/
log close


/*	ROBUSTNESS CHECK: Use vote measure indicating if "Definately will vote"	*/

ttest bvote_1, by(bg) unequal			/*	Pre-Campaign Vote Intention	*/
ttest bvote_2, by(bg) unequal			/*	Post-Campaign Vote Intention	*/


log using "Table4", replace text

/******************************************************************/
/*	Estimates of the Effect of Advertising on Turnout		*/
/*	Table 4 									*/
/******************************************************************/

/*	Number in Table is the coefficient for advrt	*/

/*  	OLS Results 		*/
/*	Table 4 column 1		*/

reg vote_2 advrt black hispanic female strngth_  pl_ntrst age union church sen gub vote_1, robust			/*	Full Sample	*/
reg vote_2 advrt black hispanic female strngth_  pl_ntrst age union church sen gub if vote_1 == 0, robust		/*	Non-Voters	-- Appendix Table 1*/
reg vote_2 advrt black hispanic female strngth_  pl_ntrst age union church sen gub if vote_1 == 1, robust		/*	Voters -- Appendix Table 1	 */

/*  Probit Results (Full Results Appendix Table 3) */
probit vote_2 black hispanic female strngth_  pl_ntrst age union church sen gub advrt vote_1, robust
probit vote_2 black hispanic female strngth_  pl_ntrst age union church sen gub advrt if vote_1 == 0, robust
probit vote_2 black hispanic female strngth_  pl_ntrst age union church sen gub advrt if vote_1 == 1, robust


/*  
	Get Average Effects (Table 4 -- column 2)
    	From Bill Evans Code:  http://www.bsos.umd.edu/econ/evans/econ626.htm
	Estimating the average treatment effect for the treated (people with advrt=1 already)    
	Table 4 column 2		
*/

/*  Full Sample */

use "NationalData",replace

probit vote_2 advrt black hispanic female strngth_  pl_ntrst age union church sen gub vote_1
gen ones=1  
matrix cov=e(V)
matrix beta=e(b)
drop if advrt==0
predict cdf1, p
predict z1, xb
gen pdf1=normd(z1)
matrix vecaccum sum1= pdf1 advrt black hispanic female strngth_  pl_ntrst age union church sen gub vote_1 [iw=1/_N]
recode advrt 1=0  
predict cdf0, p
predict z0, xb
gen pdf0=normd(z0)
matrix vecaccum sum0= pdf0 advrt black hispanic female strngth_  pl_ntrst age union church sen gub vote_1 [iw=1/_N]
matrix g=sum1-sum0
gen delta_i=cdf1-cdf0
matrix vecaccum delta= ones delta_i [iw=1/_N], noc
matrix cov_del=g*cov*g'
matrix se_del=sqrt(cov_del[1,1])
matrix list delta							/*	Full Sample ATE Estimate	*/
matrix list se_del						/*	Full Sample ATE Stnd. Err.	*/

/*  Initial non-voters  */

use "NationalData",replace

drop if vote_1 ==1
probit vote_2 advrt black hispanic female strngth_  pl_ntrst age union church sen gub if vote_1 == 0
gen ones=1  
matrix cov=e(V)
matrix beta=e(b)
drop if advrt==0
predict cdf1, p
predict z1, xb
gen pdf1=normd(z1)
matrix vecaccum sum1= pdf1 advrt black hispanic female strngth_  pl_ntrst age union church sen gub [iw=1/_N]
recode advrt 1=0  
predict cdf0, p
predict z0, xb
gen pdf0=normd(z0)
matrix vecaccum sum0= pdf0 advrt black hispanic female strngth_  pl_ntrst age union church sen gub [iw=1/_N]
matrix g=sum1-sum0
gen delta_i=cdf1-cdf0
matrix vecaccum delta= ones delta_i [iw=1/_N], noc
matrix cov_del=g*cov*g'
matrix se_del=sqrt(cov_del[1,1])
matrix list delta							/*	Non-Voter ATE Estimate		*/
matrix list se_del						/*	Non-Voter ATE Stnd. Err.	*/

/*  Initial voters  */

use "NationalData",replace

drop if vote_1 ==0
probit vote_2 advrt black hispanic female strngth_  pl_ntrst age union church sen gub if vote_1 == 1
gen ones=1  
matrix cov=e(V)
matrix beta=e(b)
drop if advrt==0
predict cdf1, p
predict z1, xb
gen pdf1=normd(z1)
matrix vecaccum sum1= pdf1 advrt black hispanic female strngth_  pl_ntrst age union church sen gub [iw=1/_N]
recode advrt 1=0  
predict cdf0, p
predict z0, xb
gen pdf0=normd(z0)
matrix vecaccum sum0= pdf0 advrt black hispanic female strngth_  pl_ntrst age union church sen gub [iw=1/_N]
matrix g=sum1-sum0
gen delta_i=cdf1-cdf0
matrix vecaccum delta= ones delta_i [iw=1/_N], noc
matrix cov_del=g*cov*g'
matrix se_del=sqrt(cov_del[1,1])
matrix list delta							/*	Non-Voter ATE Estimate		*/
matrix list se_del						/*	Non-Voter ATE Stnd. Err.	*/


use "NationalData",replace


*/  	Wald Estimates    */
*/	Table 4, column 3	*/

ivreg  vote_2 (advrt= bg), robust			/*	Full Sample	*/
ivreg  vote_2 (advrt= bg)  if vote_1==0, robust	/*	Non-Voters	*/
ivreg  vote_2 (advrt= bg)  if vote_1==1, robust	/*	Voters	*/


*/  	2SLS    					*/
*/	Table 4, column 4				*/
*/	Full Results -- Appendix Table 1	*/
ivreg vote_2 black hispanic female strngth_  pl_ntrst age union church sen gub vote_1 (advrt = bg), robust			/*	Full Sample	*/
ivreg vote_2 black hispanic female strngth_  pl_ntrst age union church sen gub (advrt = bg)  if vote_1 == 0, robust	/*	Non-Voters	*/
ivreg vote_2 black hispanic female strngth_  pl_ntrst age union church sen gub (advrt = bg)  if vote_1 == 1, robust	/*	Voters	*/


*/	Hausman Test for 2SLS discussed in Text*/

regress advrt bg black hispanic female strngth_  pl_ntrst age union church sen gub vote_1				/*	Full Sample	*/
predict res3, resid 
regress vote_2 advrt res3 black hispanic female strngth_  pl_ntrst age union church sen gub vote_1, robust
/*	Hausman test is the coefficient on res3	*/
/*  	p = .029    */

/*  	Initial Non-Voters  	*/

regress advrt bg black hispanic female strngth_  pl_ntrst age union church sen gub if vote_1 == 0	/*	Appendix -- Table 2	*/
predict res4, resid 
regress vote_2 advrt res4 black hispanic female strngth_  pl_ntrst age union church sen gub if vote_1 == 0, robust
/*	Hausman test is the coefficient on res4	*/
/*  	p = .212    */

/*  	Initial Voters  */

regress advrt bg black hispanic female strngth_  pl_ntrst age union church sen gub if vote_1 == 1	/*	Appendix -- Table 2	*/
predict res5, resid 
regress vote_2 advrt res5 black hispanic female strngth_  pl_ntrst age union church sen gub if vote_1 == 1, robust
/*	Hausman test is the coefficient on res5	*/
/*  	p = .107    */
log close

/*	Bivariate Probit Code Results see: NatBiProbit.do	*/


*/  Statistics for offsetting effects discussion in text	*/
*/	Section 3.2								*/

table vote_1 vote_2 if bg==0
table vote_1 vote_2 if bg==1

gen cng = vote_1 - vote_2
recode cng (-1=1)
ttest cng, by(bg) unequal	
