/*********************************************************************  
    Scott Ashworth
    Josh Clinton
    Princeton University
    July 2006
    Bivariate Probit Code for "Does Advertising Affect Turnout?"
    National Sample	
*********************************************************************/ 


use "NationalData",replace
compress
sum

log using "BiProbitCoefs", replace text

/*  	Bivariate Probit    									*/
/*	Full Results for votes and non-voters in Table 3 and 4 of Appendix	*/

biprobit (advrt = bg gub sen black hispanic church union female strngth_ pl_ntrst age vote_1) (vote_2=advrt church union gub sen black hispanic female strngth_ pl_ntrst age)

biprobit (advrt = bg gub sen black hispanic church union female strngth_ pl_ntrst age) (vote_2=advrt church union gub sen black hispanic female strngth_ pl_ntrst age) if vote_1 == 0

biprobit (advrt = bg gub sen black hispanic church union female strngth_ pl_ntrst age) (vote_2=advrt church union gub sen black hispanic female strngth_ pl_ntrst age) if vote_1 == 1
log close

/*	To get ATE use bootstrap	*/

log using "BiProbitEffect", replace text

set seed 331107
program drop _all				/* Clears any programs from STATA's memory	*/


/*	Define Program: Effect for Full Sample	*/
/******************************************************************************************/
program effect, rclass			/* Define a program to compute marginal effects for bivariate probit	*/
						/* This one does the full sample and conditions on vote_1			*/

gen ad1=advrt				/* Generates a new version of the treatment, so we can adjust it		*/

biprobit (ad1=bg vote_1 gub sen black black female strngth_ pl_ntrst age union church)(vote_2=ad1 vote_1 gub sen black black female strngth_ pl_ntrst age union church)

recode ad1 0=1
predict xb_1, xb2
gen cdf1=normprob(xb_1)

recode ad1 1=0
predict xb_0, xb2
gen cdf0=normprob(xb_0)

gen ate=cdf1-cdf0
sum ate, meanonly				/* Calculate the sample average treatment effect			*/

return scalar mate=r(mean)
drop ate cdf1 cdf0 xb_0 xb_1 ad1	/* Clean up the data memory		*/
end
/**************************************************************************************/

bs "effect" effect=r(mate), rep(1000)	/* Bootstraps the ATE program defined above	*/
							/* Full Sample for Table 4 column 5			*/

set seed 331107
program drop _all


/*	Define Program: Effect for Non-Voter Sample	*/
/******************************************************************************************/
program effect, rclass			/* Define a program to compute marginal effects for bivariate probit	*/
						/* This one does the full sample and conditions on vote_1			*/

gen ad1=advrt				/* Generates a new version of the treatment, so we can adjust it		*/

biprobit (ad1=bg vote_1 gub sen black black female strngth_ pl_ntrst age union church)(vote_2=ad1 vote_1 gub sen black black female strngth_ pl_ntrst age union church) if vote_1==0

recode ad1 0=1
predict xb_1, xb2
gen cdf1=normprob(xb_1)

recode ad1 1=0
predict xb_0, xb2
gen cdf0=normprob(xb_0)

gen ate=cdf1-cdf0
sum ate, meanonly				/* Calculate the sample average treatment effect			*/
return scalar mate=r(mean)
drop ate cdf1 cdf0 xb_0 xb_1 ad1	/* Clean up the data memory		*/
end
/**************************************************************************************/

bs "effect" effect=r(mate), rep(1000)	/* Bootstraps the ATE program defined above	*/
							/* Non-Voter Sample for Table 4 column 5		*/

set seed 331107
program drop _all

/*	Define Program: Effect for Voter Sample	*/
/******************************************************************************************/
program effect, rclass			/* Define a program to compute marginal effects for bivariate probit	*/
						/* This one does the full sample and conditions on vote_1			*/

gen ad1=advrt				/* Generates a new version of the treatment, so we can adjust it		*/

biprobit (ad1=bg vote_1 gub sen black black female strngth_ pl_ntrst age union church)(vote_2=ad1 vote_1 gub sen black black female strngth_ pl_ntrst age union church) if vote_1==1

recode ad1 0=1
predict xb_1, xb2
gen cdf1=normprob(xb_1)

recode ad1 1=0
predict xb_0, xb2
gen cdf0=normprob(xb_0)

gen ate=cdf1-cdf0
sum ate, meanonly				/* Calculate the sample average treatment effect			*/
return scalar mate=r(mean)
drop ate cdf1 cdf0 xb_0 xb_1 ad1	/* Clean up the data memory		*/
end
/**************************************************************************************/

bs "effect" effect=r(mate), rep(1000)	/* Bootstraps the ATE program defined above	*/
							/* Voter Sample for Table 4 column 5		*/
log close
